function opts = get_opts(inargs)
% function opts = get_opts(inargs)
% initialize opts structure from input (key-value pairs)
%
ip = inputParser;
ip.addParamValue('basedir', pwd, @isstr);
ip.addParamValue('dataset', '', @isstr);

%ip.addParamValue('cnn_arch', 'bvlc_reference_caffenet', @isstr);
%ip.addParamValue('cnn_arch', 'VGG16', @isstr);
%ip.addParamValue('cnn_arch', 'VGG19', @isstr);
ip.addParamValue('cnn_arch', 'VGG16_SalObjSub', @isstr);
ip.addParamValue('cnn_idstr', '', @isstr);
ip.addParamValue('cnn_use_fc7', true, @islogical);

ip.addParamValue('svm_ftype', 'CNN', @isstr); % CNN GIST HOG IFV
ip.addParamValue('svm_kernel', 1, @isscalar);
ip.addParamValue('pca_dim', 100, @isscalar);
ip.addParamValue('num_cvfolds', 5, @isscalar);

ip.parse(inargs{:});
opts = ip.Results;

% CNN: determine which .prototxt to use
if opts.cnn_use_fc7
    opts.cnn_prototxt = [opts.cnn_arch '_fc7'];
else
    opts.cnn_prototxt = 'deploy';
end

opts.cachedir = fullfile(opts.basedir, 'cachedir');
opts.modeldir = fullfile(opts.basedir, 'models');
opts.datadir  = fullfile(opts.basedir, 'data');
opts.extdir   = fullfile(opts.basedir, 'extern');
if ~exist(opts.cachedir, 'dir'), mkdir(opts.cachedir); end
if ~exist(opts.modeldir, 'dir'), mkdir(opts.modeldir); end
if ~exist(opts.datadir,  'dir'), mkdir(opts.datadir);  end
if ~exist(opts.extdir,   'dir'), mkdir(opts.extdir);   end
end
