function [precision, recall, ap] = get_pr(decval, ytest, npoints)
if nargin < 3, npoints = 11; end
[~, idx] = sort(decval, 'descend');
tp = (ytest(idx) == 1);
fp = 1 - tp;
tp = cumsum(tp);
fp = cumsum(fp);
precision = tp ./ (tp + fp);
recall    = tp ./ sum(ytest == 1); 
ap = 0;
for t = linspace(0, 1, npoints)
    p = max(precision(recall>=t));
    if isempty(p), p = 0; end
    ap = ap + p/npoints;
end
end
