function [precision, recall, ap] = demo_cnnft(dataset, varargin)
% fine-tuned CNN on STATIC/VizWiz, from SOS-VGG16
%
if nargin < 1, dataset = 'STATIC'; end
addpath('util');

opts = get_opts({'cnn_arch', [dataset '_ft'], varargin{:}});
opts.cnn_idstr = 'trainval';
opts.cnn_use_fc7 = false;
rand('state', 12345); % fix random seed

% load dataset (Test)
F = fullfile(opts.datadir, dataset, 'test.txt');
[names, labels] = textread(F, '%s %d');

% prediction
[softmax, featfile_test] = get_CNN_features(opts, dataset, 'Test', names);

[~, fn, ~] = fileparts(featfile_test);
resfile = sprintf('res/CNNFT_%s.mat', fn);
if exist(resfile, 'file')
    r = load(resfile);
    precision = r.precision;
    recall = r.recall; 
    ap = r.ap;
else
    decval = softmax(:, 2);   % probability of yes
    ypred  = 0+(decval>0.5);  % naive thresholding at .5

    % ground truth
    N = length(labels);
    fprintf('%d/%d Yes, ', sum(labels==1), N);
    fprintf('%d/%d No\n' , sum(labels==0), N);

    % evaluate
    [precision, recall, ap] = eval_pr(decval, labels, 11);
    save(resfile, 'precision', 'recall', 'ap');
end

figure, plot(recall, precision), grid
title(sprintf('%s %s AP=%.3f', strrep(opts.cnn_arch, '_', '-'), ...
    strrep(opts.cnn_idstr, '_', '-'), ap*100));
fprintf('AvgPrec(%d-point) = %g', 11, ap);

end
